local t = Def.ActorFrame {}

t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(Center),
	
	Def.Quad {
		InitCommand=cmd(zoomto,SCREEN_WIDTH,SCREEN_HEIGHT)
	},
	
	LoadActor(THEME:GetPathB("_common", "halftone")) .. {
		Name = "pattern",
		OnCommand=function(self)
			self:x(_screen.cx/2):zoomto(_screen.h,-_screen.cx):customtexturerect(0,0,_screen.h/1024,_screen.cx/1024):texcoordvelocity(0.01,0):
				diffuse(LocalBlueColor(1)):diffusealpha(0.25):rotationz(90)
		end
	},
	
	-- Main info...
	Def.ActorFrame {
		OnCommand=cmd(diffusealpha,1;sleep,3;linear,0.25;diffusealpha,0),
		
		LoadActor("devs") .. {
			InitCommand=cmd(scaletofit,-_screen.cx/2,-_screen.cy/2,_screen.cx/2,_screen.cy/2)
		},
		LoadFont("Common Normal") .. {
			Text=ProductFamily() .. " " .. ProductVersion(),
			InitCommand=cmd(x,-_screen.w/3;y,-_screen.cy/1.6;horizalign,left;diffuse,Color.Black;zoom,0.8;maxwidth,(_screen.w*0.7)/0.8;wrapwidthpixels,(_screen.w*0.7)/0.8)
		},
		LoadFont("Common Normal") .. {
			Text=THEME:GetThemeDisplayName(),
			InitCommand=cmd(x,-_screen.w/3;y,(_screen.cy/1.6)-10;horizalign,left;diffuse,Color.Black;zoom,0.8;maxwidth,(_screen.w*0.7)/0.8;wrapwidthpixels,(_screen.w*0.7)/0.8)
		},
		LoadFont("Common Normal") .. {
			--Text="by " .. THEME:GetThemeAuthor(),
			InitCommand=function(self)
				self:xy(-_screen.w/3,(_screen.cy/1.6) +10):horizalign(left):vertalign(top):diffuse(Color.Black):zoom(0.6):maxwidth((_screen.w*0.7)/0.8):wrapwidthpixels((_screen.w*0.7)/0.8)
				
				local RNG = math.random(1,50)
				local theString = RNG == 1 and THEME:GetString("ScreenInit", "AuthorBotched" .. tostring(math.random(1,2))) or THEME:GetThemeAuthor()
				
				self:settext("- " .. theString)
			end
		}
	},
	
	-- and warnings.
	Def.ActorFrame {
		OnCommand=cmd(diffusealpha,0;sleep,3.5;linear,0.25;diffusealpha,1;sleep,5;linear,0.25;diffusealpha,0),
		
		LoadFont("Common Normal") .. {
			Text=THEME:GetString("ScreenInit", "Seizures"),
			InitCommand=cmd(diffuse,Color.Black;zoom,0.7;wrapwidthpixels,(_screen.cx*1.5)/0.7)
		},
	}
}

return t
